/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package chapter6;

/**
 * @author Matthew Gregory
 */
public class StartHere {

    public static void main(String[] args) {

        //Introducing Arrays...
        //To create agenda items, don't do this...
//        String item1 = "Discuss Design";
//        String item2 = "Agree on Design";
//        String item3 = "Document the agreement and prepare design for publishing.";
        //We can put them all in a single variable using an array.
//        String[] agendaItems = {"Discuss Design", 
//            "Agree on Design", 
//            "Document the agreement and prepare design for publishing."};
        //Print out the second agenda item    
//        System.out.println("Second item on the agenda: " + agendaItems[1]);
        //Process the array by printing out each element using a normal for loop
//        System.out.println("Items on the Agenda: ");
//        for (int i = 0; i <= agendaItems.length-1; i++) {
//            System.out.println((i+1)+". "+agendaItems[i]);
//        }
        //Processing the array using a modified for loop
//        System.out.println("Items on the Agenda: ");
//        for (String item:agendaItems){
//            System.out.println(item);
//        }
        //Setting up the array in three steps
        //declaring the variable called moreNames, which is an array of Strings.
        String[] agendaItems;
        //creating the array with 3 elements
        agendaItems = new String[3];
        //populating the array
        agendaItems[0] = "Discuss Design";
        agendaItems[1] = "Agree on Design";
        agendaItems[2] = "Document the agreement and prepare design for publishing.";

        //testing our Meeting class
        Meeting myMeeting = new Meeting();
        myMeeting.agendaItems = agendaItems;
        myMeeting.printAgenda();

        //Creating attendees for our meeting.
        //host
        Person me = new Person("Employee", "Matthew", "Gregory", 46);
        //A Customer 
        Person cust = new Person("Customer", "John", "Citizen", 21);
        //A Person who is not an Employee nor a Customer
        Person someoneElse = new Person("Unknown", "Jane", "Doe", 32);

        //Add ‘me’ as host
        myMeeting.host = me;
        //create a new array with the remaining people and add them to my meeting.
        Person[] people = {cust, someoneElse};
        myMeeting.attendees = people;

        //print out the attendees of our meeting.
//        myMeeting.printAttendees();

        //creating a constructor
        //Passing the array as a parameter
//        Meeting anotherMeeting= new Meeting(me,people);
//        anotherMeeting.printAttendees();
        //Passing the individual attendees across as parameters
        //Without constructing an array first.
        Meeting anotherMeeting= new Meeting(me,cust,someoneElse);
//        anotherMeeting.printAttendees();
        
        //Creating a data source
        DataSource myData = new DataSource();
        for (Person p:myData.people){
            System.out.println(p);
        }
        for (Meeting m:myData.meetings){
            System.out.println("Meeting hosted by: "+m.host);
            System.out.println(m.attendees.length+" attendees.");
        }
    }

}
